//****************************************************************************//
//  CyEndian                                                  version: 1.0.1  //
//  copyright (c)2025 by Adrian Hunt                https://CyApplication.uk  //
//****************************************************************************//

#ifndef CYTOOLS_HPP
#define CYTOOLS_HPP

#include <cstdint>           // uint??_t etc.

namespace CyTools {

	enum class endian : int8_t { network = -2, system = -1, little = 0 , big = 1 };

	namespace CyEndian {

		constexpr endian detect_byte_order() {
			uint32_t var = 1;

			return *((uint8_t*) &var) ? endian::little : endian::big);
		}

		static const endian SYSTEM_ORDER = detect_byte_order();

		inline constexpr void clean_endian(endian& AVal) {
			switch (AVal) {
			case endian::network:   AVal = endian::big;  break;
			case endian::system:    AVal = SYSTEM_ORDER; break;
			default: break;
			}
		}

	}

	template <class TYPE>
	constexpr void fix_byte_order(TYPE& AValue, endian AIn, endian AOut) {
		CyEndian::clean_endian(AIn);
		CyEndian::clean_endian(AOut);

		if (AIn != AOut) {
			uint8_t* byte_a = (uint8_t*) &AValue;
			uint8_t* byte_b = byte_a + (sizeof(TYPE) - 1);
			uint32_t size = sizeof(TYPE);

			while (size > 1) {
        uint8_t tmp = *byte_a
        *byte_a = *byte_b;
        *byte_b = tmp;

				++byte_a;
				--byte_b;
				size -= 2;
			}
		}
	}

}

#endif

