
#ifndef CYCRCDEFS_HPP
#define CYCRCDEFS_HPP

#include <cstddef>           // size_t
#include <cstdint>           // uint_fast8_t etc.

namespace CyTools {

	/* template params structure...
	struct crc_params {
		typedef uint_fast??_t value_t;

		static const size_t SIZE;        // Bit width
		static const value_t POLYNOMIAL; // CRC polynomial
		static const value_t INIT_VALUE; // Initial CRC value
		static const value_t FINAL_XOR;  // Final XOR value
		static const bool REFLECT_IN;    // Reflect all input bits
		static const bool REFLECT_OUT;   // Reflect the output CRC
	};	*/

	struct crc32_bzip2_params {
		typedef uint_fast32_t value_t;

		static const size_t SIZE        = 32;
		static const value_t POLYNOMIAL = 0x04C11DB7;
		static const value_t INIT_VALUE = 0xFFFFFFFF;
		static const value_t FINAL_XOR  = 0xFFFFFFFF;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc5_usb_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 5;
		static const value_t POLYNOMIAL = 0x05;
		static const value_t INIT_VALUE = 0x1F;
		static const value_t FINAL_XOR  = 0x1F;
		static const bool REFLECT_IN    = true;
		static const bool REFLECT_OUT   = true;
	};

	struct crc16_usb_params {
		typedef uint_fast16_t value_t;

		static const size_t SIZE        = 16;
		static const value_t POLYNOMIAL = 0x8005;
		static const value_t INIT_VALUE = 0xFFFF;
		static const value_t FINAL_XOR  = 0xFFFF;
		static const bool REFLECT_IN    = true;
		static const bool REFLECT_OUT   = true;
	};

	struct crc6_cdma2000a_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 6;
		static const value_t POLYNOMIAL = 0x27;
		static const value_t INIT_VALUE = 0x3F;
		static const value_t FINAL_XOR  = 0x00;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc6_cdma2000b_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 6;
		static const value_t POLYNOMIAL = 0x07;
		static const value_t INIT_VALUE = 0x3F;
		static const value_t FINAL_XOR  = 0x00;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc10_cdma2000_params {
		typedef uint_fast16_t value_t;

		static const size_t SIZE        = 10;
		static const value_t POLYNOMIAL = 0x3D9;
		static const value_t INIT_VALUE = 0x3FF;
		static const value_t FINAL_XOR  = 0x000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc12_cdma2000_params {
		typedef uint_fast16_t value_t;

		static const size_t SIZE        = 12;
		static const value_t POLYNOMIAL = 0xF13;
		static const value_t INIT_VALUE = 0xFFF;
		static const value_t FINAL_XOR  = 0x000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc16_cdma2000_params {
		typedef uint_fast16_t value_t;

		static const size_t SIZE        = 16;
		static const value_t POLYNOMIAL = 0xC867;
		static const value_t INIT_VALUE = 0xFFFF;
		static const value_t FINAL_XOR  = 0x0000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc4_itu_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 4;
		static const value_t POLYNOMIAL = 0x3;
		static const value_t INIT_VALUE = 0x0;
		static const value_t FINAL_XOR  = 0x0;
		static const bool REFLECT_IN    = true;
		static const bool REFLECT_OUT   = true;
	};

	struct crc5_itu_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 5;
		static const value_t POLYNOMIAL = 0x15;
		static const value_t INIT_VALUE = 0x00;
		static const value_t FINAL_XOR  = 0x00;
		static const bool REFLECT_IN    = true;
		static const bool REFLECT_OUT   = true;
	};

	struct crc6_itu_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 6;
		static const value_t POLYNOMIAL = 0x03;
		static const value_t INIT_VALUE = 0x00;
		static const value_t FINAL_XOR  = 0x00;
		static const bool REFLECT_IN    = true;
		static const bool REFLECT_OUT   = true;
	};

	struct crc10_itu_params {
		typedef uint_fast16_t value_t;

		static const size_t SIZE        = 10;
		static const value_t POLYNOMIAL = 0x233;
		static const value_t INIT_VALUE = 0x000;
		static const value_t FINAL_XOR  = 0x000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc24_openpgp_params {
		typedef uint_fast32_t value_t;

		static const size_t SIZE        = 24;
		static const value_t POLYNOMIAL = 0x864CFB;
		static const value_t INIT_VALUE = 0xB704CE;
		static const value_t FINAL_XOR  = 0x000000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc32_mpeg2_params {
		typedef uint_fast32_t value_t;

		static const size_t SIZE        = 32;
		static const value_t POLYNOMIAL = 0x04C11DB7;
		static const value_t INIT_VALUE = 0xFFFFFFFF;
		static const value_t FINAL_XOR  = 0x00000000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

	struct crc7_jedec_params {
		typedef uint_fast8_t value_t;

		static const size_t SIZE        = 7;
		static const value_t POLYNOMIAL = 0x09;
		static const value_t INIT_VALUE = 0x00;
		static const value_t FINAL_XOR  = 0x000;
		static const bool REFLECT_IN    = false;
		static const bool REFLECT_OUT   = false;
	};

}

#endif
